<?php 

/**
 * SharedController Controller
 * @category  Controller / Model
 */
class SharedController extends BaseController{
	
	/**
     * dhkap_KOLEKTOR_option_list Model Action
     * @return array
     */
	function dhkap_KOLEKTOR_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT NAMA_KOLEKTOR AS value,NAMA_KOLEKTOR AS label FROM kolektor";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * dhkap_KET_SERAH_option_list Model Action
     * @return array
     */
	function dhkap_KET_SERAH_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT KET_SERAH AS value,KET_SERAH AS label FROM ket_serah";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * dhkap_CAT_BSERAH_option_list Model Action
     * @return array
     */
	function dhkap_CAT_BSERAH_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT CAT_BSERAH AS value,CAT_BSERAH AS label FROM cat_bserah";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * dhkap_KET_BAYAR_option_list Model Action
     * @return array
     */
	function dhkap_KET_BAYAR_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT JENIS_BAYAR AS value,JENIS_BAYAR AS label FROM jenis_bayar";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * dhkap_CAT_BBAYAR_option_list Model Action
     * @return array
     */
	function dhkap_CAT_BBAYAR_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT CAT_BBAYAR AS value,CAT_BBAYAR AS label FROM cat_bbayar";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * dhkap_KETERANGAN_option_list Model Action
     * @return array
     */
	function dhkap_KETERANGAN_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT KETERANGAN AS value,KETERANGAN AS label FROM keterangan";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * terhutang_KOLEKTOR_option_list Model Action
     * @return array
     */
	function terhutang_KOLEKTOR_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT NAMA_KOLEKTOR AS value,NAMA_KOLEKTOR AS label FROM kolektor";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * user_USER_value_exist Model Action
     * @return array
     */
	function user_USER_value_exist($val){
		$db = $this->GetModel();
		$db->where("USER", $val);
		$exist = $db->has("user");
		return $exist;
	}

	/**
     * user_EMAIL_value_exist Model Action
     * @return array
     */
	function user_EMAIL_value_exist($val){
		$db = $this->GetModel();
		$db->where("EMAIL", $val);
		$exist = $db->has("user");
		return $exist;
	}

	/**
     * getcount_bayarviakolektor Model Action
     * @return Value
     */
	function getcount_bayarviakolektor(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM data_bayar_kolektor";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_bayarlangsung Model Action
     * @return Value
     */
	function getcount_bayarlangsung(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM data_bayar_langsung";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_spptbelumbayar Model Action
     * @return Value
     */
	function getcount_spptbelumbayar(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM data_belum_bayar";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_spptbelumserah Model Action
     * @return Value
     */
	function getcount_spptbelumserah(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM data_belum_serah";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

}
