<?php 
/**
 * Capaian Page Controller
 * @category  Controller
 */
class CapaianController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "capaian";
	}
	/**
     * Custom list page
     * @return BaseView
     */
	function index(){
		$request = $this->request;
		$db = $this->GetModel();
		$pagination = null;
		$sqltext = "SELECT SQL_CALC_FOUND_ROWS   COUNT(d.NOP) AS count_of_NOP, SUM(d.KETETAPAN) AS sum_of_KETETAPAN, d.KOLEKTOR, l.LUNAS FROM dhkap AS d JOIN lunas AS l ON d.KETERANGAN=l.LUNAS GROUP BY d.KOLEKTOR";
		$queryparams = null;
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("count_of_NOP", ORDER_TYPE);
		}
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); //Get sql limit from url if not set on the sql command text
		$tc = $db->withTotalCount();
		$records = $db->query($sqltext, $pagination, $queryparams);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = (!empty($pagination) ? $pagination[1] : 1);
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Capaian";
		$this->render_view("capaian/list.php", $data); //render the full page
	}
}
